<?php
////////////////////////////////////////////////////////////////////////////////
// CUSTOMIZE THE VALUES BELOW ONLY
$DEFAULT_PAGE_TITLE = "Search This Site";
$URL = "search.php";                       // name of this file (used for the translation feature)

// Left Info Bars
$searchBar    = 1; // 1 = Show / 0 = Hide
$translateBar = 1; // 1 = Show / 0 = Hide
$contactBar   = 1; // 1 = Show / 0 = Hide
$mirrorBar    = 1; // 1 = Show / 0 = Hide

// Right Info Bars
$relatedLinksBar = 0; // 1 = Show / 0 = Hide
$graphicsBar     = 0; // 1 = Show / 0 = Hide
$featureBar      = 1; // 1 = Show / 0 = Hide
$dykBar          = 1; // 1 = Show / 0 = Hide

// DO NOT CUSTOMIZE BELOW THIS POINT
////////////////////////////////////////////////////////////////////////////////
?>
<!DOCTYPE HTML> 
<HTML lang="en">
<HEAD>
    <script type="application/ld+json"> 
{ "@context": 
"http://www.schema.org", "@type": "WebSite", "name": "Vasant Corporation", 
"url": "https://www.vasantcorporation.com/search.php", "potentialAction": { "@type": "SearchAction", "target": 
"URL structure of internal site search", "query-input": "required name=search_term"} } }
</script>      
<meta charset="UTF-7">
<?php
require_once("includes/html_output.php");
require_once("includes/db.php");

$search = stripslashes(trim($_GET["search"]));
$searchOK = (@isSet($search) && $search != "" && strlen($search) > 2) ? true : false;
$title = ($searchOK) ? "Search results for '$search'" : $DEFAULT_PAGE_TITLE;
?>
<META NAME="description" CONTENT="Website search results page">
<META NAME="keywords" CONTENT="Website search results page">
<meta property="og:title" CONTENT="Website search results page" />
<META property="og:description" content="Website search results page" />
<META property="og:keywords" content="Website search results page" />
<meta property="og:type" content="website" />
<meta property="og:url" content="https://www.vasantcorporation.com/<?php echo $URL; ?>" />
<?php

insertLinkTags();
insertMenuScript();
insertOpenWinScript();
?>

<TITLE><?php echo $title ?></TITLE>


</HEAD>

<BODY TOPMARGIN=0 LEFTMARGIN=0 BGCOLOR="#D7E1E9">

<?php
insertHeader();
insertMenu();
insertVSpacer(34);
?>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=760 ALIGN=center>
 <TR>
  <TD WIDTH=100% VALIGN=top>

  <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=100%>
   <TR>


    <TD VALIGN=top>
    <IMG SRC="images/spacer.gif" HEIGHT=1 WIDTH=5 alt="spacer image"><BR>
    </TD>

    <TD WIDTH=60% VALIGN=top>

    <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=100%>
     <TR>
      <TD WIDTH=100% COLSPAN=2>

     <TABLE BORDER=1 STYLE="border: 1px;" CELLSPACING=0 CELLPADDING=10 BORDERCOLOR="black" BGCOLOR="white" WIDTH=100%>
     <TR>
     <TD ALIGN=center>
<?php
insertTitleBar($title);
?>
    <BR>
    <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=100% HEIGHT=300>
     <TR>
      <TD WIDTH=7% VALIGN=top>
      <IMG SRC="images/spacer.gif" HEIGHT=1 WIDTH=30 alt="spacer image"><BR>
      </TD>
      <TD WIDTH=86% VALIGN=top>
<?php
function formatExcerpt($str, $search, $startPos, $eLength) {
   $output = "\"";
// strip word fragments at beginning of string if string does start at beginning of file
if ($startPos != 0) {
   $output .= "... ";
   for ($i=0; $i < 100; $i++) {
      if (substr($str,0,1) != " ") {
         $str = substr($str,1);
      } else {
         $str = substr($str,1);
         break;
      }
   }
}
   
// strip word fragments at end of string
if ($eLength != null) {
   for ($i=0; $i < 100; $i++) {
      if (substr($str,-1) != " " && substr($str,-1) != ".") {
         $str = substr($str,0,strlen($str)-2);
      } else {
         break;
      }
   }
}

// highlight search word
$lower = strtolower($search);
$upper = strtoupper($search);
$ucase = ucwords($search);
$words = array($lower, $upper, $ucase);

foreach($words as $keys => $val) {
   $hilite = "<SPAN STYLE=\"background-color: #FFFF66\">$val</SPAN>";
   // echo 'val '.$val.' hilite '.$hilite.' str '.$str;
   $str = str_replace($val, $hilite, $str);
}
   $end = ($eLength!=null) ? "..." : "" ;
   $output .= "$str $end\"";
   return $output;
}

function getRankImg($r) {
    if ($r >= 90)
       $img = 100;
    if ($r < 90 && $r >= 70)
       $img = 80;
    if ($r < 70 && $r >= 50)
       $img = 60;
    if ($r < 50 && $r >= 30)
       $img = 40;
    if ($r < 30)
       $img = 20;
    return "$img.gif";
}

if ($searchOK) {

$search = htmlspecialchars(strip_tags(strtolower($search)));

$output = "<P>";
$hitsArray = array();
$linksArray = array();
$excerptArray = array();
$hits = 0;
$i = 0;
while ($i < count($menu)) {
   $id = $menu[$i]["ID"];
   $subMenu = $$id;
   $j = 1;
   while ($j < count($subMenu)+1) {
      $filename = $subMenu[$j]['File'];
      if ($filename != "") {
          $filename = "content/".$filename;
          $fp = fopen($filename, "r");
          $fstring = fread($fp, filesize($filename));
          fclose($fp);
          $fstring = strtolower($fstring);
          $fstring = strip_tags($fstring);
          $pattern = "@[\.|,|[:space:]]?".$search."[\.|,|[:space:]]?@";
          if (preg_match($pattern, $fstring)) {
              $h = 0;
              $lcString = strtolower($fstring);
              while (stristr($lcString, $search)) {
                  $pos = strpos($lcString, $search);
                  if ($h == 0) {
                      $startPos = ($pos > 50) ? $pos-50 : 0;
                      $eLength = ($pos < (strlen($fstring)-100)) ? 200 : null;
                      $excerpt = ($eLength != null) ? substr($fstring, $startPos, $eLength) : substr($fstring, $startPos);
                      $excerptArray[] = formatExcerpt($excerpt, $search, $startPos, $eLength);
                  }
                  $lcString = substr_replace($lcString, " ", $pos, strlen($search));
                  $h += 1;
              }
              
              $hitsArray[] = $h;
              $linksArray[] = "<A HREF=\"".$subMenu[$j]['Link']."?search=$search\">".$subMenu[$j]['Title']."</A>";
              $hits += 1;
          }
      }
      $j += 1;
   }
   $i += 1;
}

// Sort hitsArray by number of hits
if ($hits > 0) {
$rankArray = $hitsArray;
arsort($hitsArray);
rsort($rankArray);

@$ratio = 100 / $rankArray[0]; // Divide highest number of hits by 100 to calculate percntage

$hit = [];
foreach($hitsArray as $hit => $val) {
//while ($hit = each($hitsArray)) {
   $link = $linksArray[$hit];
   $numHits = $hitsArray[$hit];
   $excerpt = $excerptArray[$hit];
   $rank = $numHits * $ratio;
   $rankImg = getRankImg($rank);
   $label = ($numHits == 1) ? "$numHits match" : "$numHits matches";;
   $output .= "$link<BR><IMG SRC=\"images/$rankImg\" WIDTH=63 HEIGHT=13 ALIGN=absmiddle> <B>($label)</B><BR>$excerpt<BR><BR>\n";
   $i += 1;
}

$output .= "</P>";

   $str = ($hits == 1) ? "$hits HIT" : "$hits HITS";
//   insertSearchForm($search);
   echo "<P><B>$str</B>";
   echo "<P>The following pages contain the word(s) '<B>$search</B>':<HR>";
   echo $output;
} else {
   echo "<P><B>0 HITS</B></P>";
echo "<TABLE BORDER=1 STYLE=\"border: 1px solid orange;\" CELLSPACING=0 CELLPADDING=5 WIDTH=100% BORDERCOLOR=orange><TR><TD WIDTH=100% ALIGN=center>\n";
echo "<P>The word(s) '<B>$search</B>' could not be found within the searchable pages of this site.";
echo "</TD></TR></TABLE><BR>";
//   insertSearchForm($search);
}

} else if (@isSet($search) && strlen($search) <= 2 ) {
echo "<TABLE BORDER=1 STYLE=\"border: 1px solid orange;\" CELLSPACING=0 CELLPADDING=5 WIDTH=100% BORDERCOLOR=orange><TR><TD WIDTH=100% ALIGN=center>\n";
echo "<P>Please enter a search word that is at least 3 characters long. Thank you.</P>\n";
echo "</TD></TR></TABLE><BR>";
//insertSearchForm($search);
} else {
//insertSearchForm($search);
}

?>
      </TD>
      <TD WIDTH=7% VALIGN=top >
      <IMG SRC="images/spacer.gif" HEIGHT=1 WIDTH=30 alt="spacer image"><BR>
      </TD>
     </TR>
    </TABLE>
<?php
insertFooterBar($menu);
?>
        </TD>
       </TR>
      </TABLE>
      </TD>
      <TD WIDTH=5 BGCOLOR=#A3A9AE STYLE="top-margin:0;" VALIGN=top>
      <IMG SRC="images/no_shadow.gif" HEIGHT=5 WIDTH=5 VALIGN=abstop alt="no shadow image"><BR>
      </TD>
     </TR>
     <TR>
      <TD WIDTH=175 BGCOLOR=#A3A9AE STYLE="top-margin:0;" VALIGN=top ALIGN=left COLSPAN=3>
      <IMG SRC="images/no_shadow.gif" HEIGHT=5 WIDTH=5 VALIGN=abstop alt="no shadow image"><BR>
      </TD>
     </TR>
    </TABLE>

    </TD>

    <TD VALIGN=top>
    <IMG SRC="images/spacer.gif" HEIGHT=1 WIDTH=5 alt="spacer image"><BR>
    </TD>


   </TR>
  </TABLE>

  </TD>
 </TR>
</TABLE>
<BR>
    <font  style="font-size:0px"><h1>Website Search</h1></font>
</BODY>

</HTML>
