<?php
////////////////////////////////////////////////////////////////////////////////
// CUSTOMIZE THE VALUES BELOW ONLY

$PAGE_TITLE = "Energy and Gravity Research from the Vasant Corporation";
$URL = "";  // name of this file (used for the translation feature)

// Left Info Bars
$searchBar    = 1; // 1 = Show / 0 = Hide
$translateBar = 1; // 1 = Show / 0 = Hide
$contactBar   = 1; // 1 = Show / 0 = Hide
$mirrorBar    = 1; // 1 = Show / 0 = Hide

// Right Info Bars
$relatedLinksBar = 0; // 1 = Show / 0 = Hide
$graphicsBar     = 0; // 1 = Show / 0 = Hide
$featureBar      = 1; // 1 = Show / 0 = Hide
$dykBar          = 1; // 1 = Show / 0 = Hide

// DO NOT CUSTOMIZE BELOW THIS POINT
////////////////////////////////////////////////////////////////////////////////
?>

<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-HSCND4VHZC">
</script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-HSCND4VHZC');
</script>

<!DOCTYPE HTML> 

<HTML lang="en">
<HEAD>
    
    <meta charset="UTF-8">
<meta name="Description" CONTENT="Research of free energy or over unity devices and devices with claimed antigravity side effects to determine validity of claims.">
<script type="application/ld+json">
{
  "@context": "http://schema.org/",
  "@type": "Corporation",
       "legalName" : "Vasant Corporation",
       "description" : "Vasant Corporation provides high technology designs, products and services. Vasant Corporations specializes in research, development and consulting for Spin Wave Technology, a technology developed from research of so called free energy devices and devices with gravity modification behavior.",
       "url" : "https://www.vasantcorporation.com",
       "address": {
           "@type": "PostalAddress",
           "addressLocality" : "Fort Worth",
           "addressCountry" : "US",
           "postalCode" : "76108",
           "streetAddress": "116 Hallvale Drive"
       },
       "logo" : "https://www.vasantcorporation.com/images/vasantcorp-logo.jpg",
       "sameAs" : [
           "https://www.facebook.com/vasantcorp/",
           "https://www.twitter.com/vasantcorp",
           "https://www.linkedin.com/company/vasantcorp",
           "https://www.youtube.com/user/narivasant"]
   }
</script>

<?php
require_once("includes/html_output.php");
require_once("includes/db.php");
$title = "A New Approach to Power Generation and Propulsion";
$filename = "home.txt";
$metaDescription = "Research of claimed free energy or over unity devices and devices with claimed antigravity side effects to determine validity of claims."
?>

<meta name="referrer" content="origin"/>
<meta name="referrer" content="origin-when-crossorigin"/>
<meta name="referrer" content="origin-when-cross-origin"/>

<meta property="og:title" content="Vasant Corporation Homepage" />

<META http-equiv="Pragma" content="no-cache">  



<meta property="og:description" content="Research of claimed free energy or over unity devices and devices with claimed antigravity side effects to determine validity of claims." />
<META NAME="keywords" CONTENT="quantum physics, quantum mechanics, electro magnetic wave, quantum theory, standing wave, quantum physics is, define wave, quantum gravity, type of wave, energy electromagnetic, waves physics, energy waves, spin j, energy quantum, quantum electrodynamics, electron spin, the quantum theory, spin wave, wave em, definition quantum mechanics, quantum particles, electron wave, waves and particles, magnetic spins, quantum spin">
<meta property="og:keywords" content="quantum physics, quantum mechanics, electro magnetic wave, quantum theory, standing wave, quantum physics is, define wave, quantum gravity, type of wave, energy electromagnetic, waves physics, energy waves, spin j, energy quantum, quantum electrodynamics, electron spin, the quantum theory, spin wave, wave em, definition quantum mechanics, quantum particles, electron wave, waves and particles, magnetic spins, quantum spin" />

<link rel="alternate" media="only screen and (max-width: 720px)" href="//www.vasantcorporation.com"/>

<meta property="og:type" content="website" />
<meta property="og:url" content="https://www.vasantcorporation.com" />
<META name="robots" content="index,follow,all">
<?php
insertLinkTags();

?>

<TITLE><?php echo $PAGE_TITLE; ?></TITLE>
</HEAD>
<BODY TOPMARGIN=0 LEFTMARGIN=0 BGCOLOR="#D7E1E9">

<?php
insertHeader();
insertVSpacer(34);
?>
  <TABLE align=center BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=760>
   <TR>


    <TD  VALIGN=top>
<?php



insertMainWindow($title, $filename, $menu, $search);
?>
    </TD>

   </TR>
  </TABLE>

    
</BODY>

</HTML>
