<?php
/////////////////////////////////////////////
// BEST VIEWED WITH 'WORD WRAP' TURNED OFF //
/////////////////////////////////////////////

// MAIN MENU ITEMS==============================================================
// FORMAT: $arrayName[n] = array("Title" => "Menu Item Title",     (Limit to 15 characters)
//                               "ID" => "arrayName",              (Name of the array and PHP file associated with this item)
//                               "Size" => "menu width");          (For customizing the width of each menu)
$menu[0] = array("Title" => "Publications",
                 "ID" => "pubs",
                 "Size" => "150");

$menu[1] = array("Title" => "Articles",
                 "ID" => "articles",
                 "Size" => "170");
                 
$menu[2] = array("Title" => "News",
                 "ID" => "news",
                 "Size" => "130");
                 
$menu[3] = array("Title" => "Links",
                 "ID" => "links",
                 "Size" => "170");

$menu[4] = array("Title" => "Services",
                 "ID" => "services",
                 "Size" => "150");

$menu[5] = array("Title" => "Downloads",
                 "ID" => "downloads",
                 "Size" => "150");
                 
$menu[6] = array("Title" => "About Us",
                 "ID" => "about",
                 "Size" => "150");

// DEFAULTS ====================================================================
// Use these the default META description and keywords when there is no customization needed
$defaultDescription = "Research files, instructional videos, learning materials, and lectures on spin wave technology and devices for power generation, propulsion, signal processing and communications via electromagnetic particle spin interactions involving changing spin axis orientations.";
$defaultKeywords  = "quantum physics, quantum mechanics, electro magnetic wave, quantum theory, standing wave, quantum physics is, define wave, quantum gravity, type of wave, energy electromagnetic, waves physics, energy waves, spin j, energy quantum, quantum electrodynamics, electron spin, the quantum theory, spin wave, wave em, definition quantum mechanics, quantum particles, electron wave, waves and particles, magnetic spins, quantum spin";

// ARTICLES ====================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here",          (Limit to 50 characters)
//                               "File" => "filename.txt",              (Name of .txt file to be read into the content section of the web page)
//                               "Link" => "url.goes.here"              (Enter destination URL if different from the array name. Leave blank for no URL. If URL is entered, data under "File" will be ignored)
//                               "Description" => "Text goes here",     (Meta description to be included on page. Use $defaultDescription if the description for that page does not need to be customized. Description for the homepage must be edited in 'index.php')
//                               "Keywords" => "keyword1 keyword2 ...", (Meta keywords to be included on the page. Use $defaultKeywords if the keywords for that page do not need to be customized. Keywords for the homepage must be edited in 'index.php')
//                               "Menu" => [0 / 1] );                   ('1' means the item will appear on the menu, '0' means it will not.)
// NOTE ABOUT KEYWORDS:
// If you want to have it use the default keywords plus a few customized words added on then you can do so like this:
//
// "Keywords" => "$defaultKeywords custom keywords here", (to add the keywords to the end)
// ... or ...
// "Keywords" => "custom keywords here $defaultKeywords", (to add the keywords to the beginning)
//
// Note that the entire text string is enclosed in double quotes and that there is a space between
// the keyword and the variable. PHP treats the $defaultKeywords variable as if it was the entire
// string of text it represents.

$articles[1] = array("Title" => "Overview of Spin Wave Technology",
                     "File" => "articles/overview_of_swt.txt",
                     "Link" => "overview-of-swt.php",
                     "Description" => "Online and downloadable overview presentations of Spinwave Technology in English and Spanish. The English version will translate to other languages using this website's translate feature.",
                     "Keywords" => "magnonics, spin wave, spin waves, magnetic dipole, particle spin, gyroscopic precession, electron precession, electron spin, solid state physics, magnetic moment, magnon, magnons, condensed matter solid state solidstate physics",
                     "Menu" => 1);

$articles[2] = array("Title" => "About Spin Waves",
                     "File" => "articles/about_spin_waves.txt",
                     "Link" => "about-spinwaves.php",
                     "Description" => "A description of what spin waves are with links to animations to understand spin waves in a classical way.",
                     "Keywords" => " Magnonics, magnons, spin wave, spin waves, magnetic dipole, particle spin, gyroscopic precession, electron precession, electron spin, solid state physics, magnetic moment, magnon, magnons",
                     "Menu" => 1);

$articles[3] = array("Title" => "About Spin Wave Lasers",
                     "File" => "articles/about_spin_wave_lasers.txt",
                     "Link" => "about-spinwave-lasers.php",
                     "Description" => "A description of what spin wave laser are with comparisons to traditional lasers.",
                     "Keywords" => "spin superradiance, spin super-radiance, spin wave laser, spin superradiant, magnon laser, coherent spin waves, coherent photons, population inversion, hysteresis characteristics, magnetic hysteresis, hysteresis avalanches, hysteresis avalanches, magnetic avalanche, laser fundamentals, laser tutorial, larmor frequency, frequency precess, frequency precession, magnetocaloric effect, curie tempurature",
                     "Menu" => 1);

$articles[4] = array("Title" => "What Can Spin Wave Technology Do?",
                     "File" => "articles/what_can_swt_do.txt",
                     "Link" => "what-can-swt-do.php",
                     "Description" => "A description of what spin wave technology can do in 4 categories of signal processing, communications, power generation and propulsion.",
                     "Keywords" => "spin wave signal processing, spin wave communications, spin wave propulsion, spin wave power generation, cigar shape vehicle, flying vehicle, flying saucer, antigravity, electrogravity, electro gravity, electro-gravity, electro-inertial, electromagnetic inertia, matter interia, matter standing waves",
                     "Menu" => 1);
                     
$articles[5] = array("Title" => "Particle Spin and Propulsion",
                     "File" => "articles/particle_spin_propulsion.txt",
                     "Link" => "particle-spin-propulsion.php",
                     "Description" => "A description of particle spin in a classical way and explanations of how particle spin characteristics can be modified to propel matter relative to all other matter.",
                     "Keywords" => "hbar, planck's constant, 2 slit experiment, two slit experiment, destructive interference, construction interference, precessional phase, standing waves, electromagnetic waves, exchange interaction, exchange energy, exchange coupling, spin state, precessional frequencies, spin propulsion",
                     "Menu" => 1);
                     
$articles[6] = array("Title" => "Spin Superradiance and Power Generation",
                     "File" => "articles/spin_superradiance_power_generation.txt",
                     "Link" => "spin-superradiance-power-generation.php",
                     "Description" => "General theory of how a spin superradiance device could be used for electrical power generation.",
                     "Keywords" => "power generation, anisotropic magnetic, acicular magnetic, homogeneous magnetic, magnetic field,  Lenz's law, resonant cavity, microwave frequencies, coercivity, ceramic nanocrystal, coherent precession",
                     "Menu" => 1);
                     
$articles[7] = array("Title" => "The Nature of Time",
                     "File" => "articles/nature_of_time.txt",
                     "Link" => "nature-of-time.php",
                     "Description" => "This is the first science paper written by George Bugh and it describes how our perception of motion through time is not how matter really moves through time at the substomic level.",
                     "Keywords" => "nature time, 3d time, 3 dimensional time, time physics, time electromagnetic, time research",
                     "Menu" => 1);
                     
$articles[8] = array("Title" => "Magnetic Levitation With Spin Waves",
                     "File" => "articles/swt_magnetic_levitation.txt",
                     "Link" => "swt-magnetic-levitation.php",
                     "Description" => "A review of magnetic levitation techniques provided to help people understand how to do something similar at microwave frequncies by pushing against the naturally occuring magnetic waves from Earth that are responsible for the gravitational force.",
                     "Keywords" => "maglev, magnetic levitation, magnetic levitation research, maglev research, maglev transportation, magnetic levitation transportation, maglev spin waves, magnetic levitation spin waves, antigravity, electrogravity",
                     "Menu" => 1);

$articles[9] = array("Title" => "The Poynting Vector of an Electron",
                     "File" => "articles/poynting_vector_of_an_electron.txt",
                     "Link" => "poynting-vector-of-an-electron.php",
                     "Description" => "The Poynting vector of an electron can be described in a classical way. Professor Richard Feynman had contented that a classical description could not work but this article describes how it can.",
                     "Keywords" => "poynting vector, electron angular momentum, electromagnetic field, inertia energy flow vortex",
                     "Menu" => 1);

$articles[10] = array("Title" => "Spin, Pauli Exclusion, Compensated and Uncompensated",
                     "File" => "articles/spin_pauli_exclusion_compensated.txt",
                     "Link" => "spin-pauli-exclusion-compensated.php",
                     "Description" => "An explanation of how electron spin can be understood in a classical way and the 'electron spin' of quantum electrodynamics is actually the precession axis of a classical electron.",
                     "Keywords" => "electron spin,  pauli exclusion, compensated spin, uncompensated spin,compensated spins, uncompensated spins",
                     "Menu" => 1);
                     
$articles[11] = array("Title" => "Making Pseudo Element 115",
                     "File" => "articles/making_pseudo_element_115.txt",
                     "Link" => "making-pseudo-element-115.php",
                     "Description" => "A description of how something resembling element 115 can be created by layers of Bose-Einstein condensates with interleaved atomic lattices and used in a spin superradiance chamber resembling Bob Lazar's antimatter reactor.",
                     "Keywords" => "element 115 antimatter boblazar element115 area 51 area51 element 115, bob lazar antimatter reactor Bose Einstein condensation",
                     "Menu" => 1);
                     
$articles[12] = array("Title" => "The Equivalence Principle: Gravitational mass versus Inertial mass",
                     "File" => "articles/gravitational_mass_versus_inertial_mass.txt",
                     "Link" => "gravitational-mass-versus-inertial-mass.php",
                     "Description" => "Gravitational mass vs versus inertial mass; this article contends that gravitational and inertial characteristics of matter rise from different but related exchange interactions among subatomic particles.",
                     "Keywords" => "gravity inertia vs mass externalfieldeffect external field effect MordehaiMilgrom StacyMcGaugh modifiedgravity mond theory nasa ModifiedNewtonianDynamics astrophysics Mordehai Milgrom Stacy McGaugh modified gravity Modified Newtonian Dynamics physics lab ",
                     "Menu" => 1);   
                     
$articles[13] = array("Title" => "Gluon Frequency in Heavy Elements",
                     "File" => "articles/gluon_frequency_in_heavy_elements.txt",
                     "Link" => "gluon-frequency-in-heavy-elements.php",
                     "Description" => "The article contends that the phenomena of nucleons increasing in size in the nuclei of heavier elements can be explained in a classical way and occurs due to changes in the frequency of the gluon strong force carriers exchanged between quarks.",
                     "Keywords" => "gluon gluons nucleon nucleons heavy elements element 115 bob lazar antimatter reactor gravity a b wave nuclear strong force astrophysics aeronauticalengineering aeronautics aerospace space usaf ussf",
                     "Menu" => 1); 
                     
$articles[14] = array("Title" => "What is a Free Energy Device?",
                     "File" => "articles/what_is_a_free_energy_device.txt",
                     "Link" => "what-is-a-free-energy-device.php",
                     "Description" => "Research dispels preconceived/prejudiced ideas some have that so called 'free energy' devices must violate the law of conservation of energy.",
                     "Keywords" => "Free energy device, What is a free energy device, Energy generation, Renewable energy, Sustainable energy, Alternative energy, Clean energy, Energy technology, Energy efficiency, Green energy, Free energy device, Alternative energy technology, Renewable energy device, Energy efficiency, Sustainable energy device, Clean energy technology, Zero-point energy device, Perpetual motion machine, Overunity device",
                     "Menu" => 1); 

$articles[15] = array("Title" => "Spinwave Diagrams",
                     "File" => "articles/spinwave_diagram.txt",
                     "Link" => "spinwave-diagram.php",
                     "Description" => "Diagrams of spinwaves in a line, in 2 dimensions and a link to animations of spinwaves among compenstaed spins.",
                     "Keywords" => "Spinwaves, Magnetic waves, Magnetic excitations, Spin wave spectroscopy, Spin wave theory, Spin wave dynamics, Spin wave applications, Spin wave devices, Spin wave sensors, Spinwave spectroscopy, Spinwave theory, Spinwave dynamics, Spinwave applications, Spinwave devices, Spinwave sensors",
                     "Menu" => 1);   


// PUBLICATIONS ================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here", (Limit to 50 characters)
//                               "File" => "filename.txt",     (Name of .txt file to be read into the content section of the web page)
//                               "Menu" => [0 / 1] );          ('1' means the item will appear on the menu, '0' means it will not.)
$pubs[1] = array("Title" => "Spin Wave Technology CD",
                 "File" => "pubs/vc001.txt",
                 "Link" => "vc001.php",
                 "Description" => "A summary of the Vasant Corporation's first publication of the research files of George J Bugh in the form of a computer CD.",
                 "Keywords" => "spinwave technology research publication george bugh spinwaves",
                 "Menu" => 1);

$pubs[2] = array("Title" => "About the Author",
                 "File" => "pubs/about_author.txt",
                 "Link" => "about-author.php",
                 "Description" => "Biography and historical information about George Bugh the author of Spin Wave Technology",
                 "Keywords" => "George Bugh, USAF, flight simulator, BSEE, BSEET, Devry institute, aerospace, defense, engineer, amateur radio, 4h club, boy scouts",
                 "Menu" => 0);

$pubs[3] = array("Title" => "Introduction to the Spin Wave Technology CD",
                 "File" => "pubs/intro_vc001.txt",
                 "Link" => "intro-vc001.php",
                 "Description" => "Publication introduction, summary of the research published on the spin wave technology CD.",
                 "Keywords" => "spin wave technology CD, research papers",
                 "Menu" => 0);

$pubs[4] = array("Title" => "Spin Wave Technology Book",
                 "File" => "pubs/vc002.txt",
                 "Link" => "vc002.php",
                 "Description" => "A summary of the Vasant Corporation's second publication of the research files of George J Bugh in the form of a paperback book.",
                 "Keywords" => "spin wave technology research papers paperback book",
                 "Menu" => 1);
                 
$pubs[5] = array("Title" => "About the Author",
                 "File" => "pubs/about_author.txt",
                 "Link" => "about-author.php",
                 "Description" => "?Biography and historical information about George Bugh the author of Spin Wave Technology",
                 "Keywords" => "George Bugh, USAF, flight simulator, BSEE, BSEET, Devry institute, aerospace, defense, engineer, amateur radio, 4h club, boy scouts",
                 "Menu" => 0);
                 
$pubs[6] = array("Title" => "Introduction to the Spin Wave Technology Book",
                 "File" => "pubs/intro_vc002.txt",
                 "Link" => "intro-vc002.php",
                 "Description" => "Publication introduction, summary of the research published as a paperback book about spin wave technology.",
                 "Keywords" => "spin wave technology, paperback book, research papers",
                 "Menu" => 0);

// LINKS =======================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here", (Limit to 50 characters)
//                               "File" => "filename.txt",     (Name of .txt file to be read into the content section of the web page)
//                               "Menu" => [0 / 1] );          ('1' means the item will appear on the menu, '0' means it will not.)

                  
$links[1] = array("Title" => "MIRROR WEBSITES",
                  "File" => "links/mirror-sites.txt",
                  "Link" => "mirror-sites.php",
                  "Description" => "Links to our mirror websites, ",
                  "Keywords" => "mirror websites, ",
                  "Menu" => 1);
                  
$links[2] = array("Title" => "Magnetism and Magnetic Materials",
                  "File" => "links/magnetism.txt",
                  "Link" => "magnetism.php",
                  "Description" => "Links to websites about the fundamentals of magnetism and magnetic materials",
                  "Keywords" => "magnetism, magnetic materials, How Magnets Work, Hysteresis, Magnetocaloric Effect",
                  "Menu" => 1);
                  
$links[3] = array("Title" => "Electromagnetics, the Original Quaternions",
                  "File" => "links/electromagnetics.txt",
                  "Link" => "electromagnetics.php",
                  "Description" => "Links to websites about the fundamentals of electromagnetics and a possible link between electromagnetism and gravity",
                  "Keywords" => "Quaternion, Maxwell's equations,Classical Hamiltonian quaternions, electromagnetic equations, Oliver Heaviside, gravity, spacetime",
                  "Menu" => 1);
                  
$links[4] = array("Title" => "Entropy, Rotational versus Rectilinear",
                  "File" => "links/entropy.txt",
                  "Link" => "entropy.php",
                  "Description" => "Links to websites about the fundamentals of entropy and information about entropy of rectilinear motion versus reverse entropy of rotational motions of electric or magnetic dipoles.",
                  "Keywords" => "entropy, Thermodynamics, Maxwellian Demon, Maxwell's Demon",
                  "Menu" => 1);
                  
$links[5] = array("Title" => "Particle Spin, Spin Resonance and Spin Waves",
                  "File" => "links/particle_spin.txt",
                  "Link" => "particle-spin.php",
                  "Description" => "Links to websites about the fundamentals of Particle Spin, Spin Resonance and Spin Waves",
                  "Keywords" => "Particle Spin, Nuclear Magnetic Resonance, Electron Paramagnetic Resonance, Electron Spin Resonance",
                  "Menu" => 1);
                  
$links[6] = array("Title" => "Academic Research into Inertia and Gravity",
                  "File" => "links/inertia.txt",
                  "Link" => "inertia.php",
                  "Description" => "Links to websites about the fundamentals of Inertia and Gravity",
                  "Keywords" => "inertia, inertial, gravity, gravitational, gravity wave, gravitational wave, Zero Point Field Lorentz Force, Quantum Vacuum Inertia Hypothesis, inertial mass, gravitational mass, quantum vacuum fields, accelerated motion",
                  "Menu" => 1);

$links[7] = array("Title" => "Poynting Vector",
                  "File" => "links/poynting.txt",
                  "Link" => "poynting.php",
                  "Description" => "Links to websites with information about what a poynting vector is and about Poynting Vectors of static fields",
                  "Keywords" => "poynting vector, poynting vectors, static field, energy flow, energy direction, electric field, magnetic fields, propagation direction",
                  "Menu" => 1);
$links[8] = array("Title" => "Archive of all past links",
                  "File" => "links/links_archive.txt",
                  "Link" => "links-archive.php",
                  "Description" => "A zip file archive of old original websites George Bugh researched while developing his science theories",
                  "Keywords" => "spin wave technology, website archive, research files",
                  "Menu" => 1);
$links[9] = array("Title" => "Gravity videos",
                  "File" => "links/gravity_videos.txt",
                  "Link" => "gravity-videos.php",
                  "Description" => "Links to George Bugh's videos on Youtube.com about his theory of gravity, how matter creates gravity, where gravitational force comes from.",
                  "Keywords" => "gravity, gravitational, gravitational mass, instructional video, science video, training video, research video",
                  "Menu" => 1);
$links[10] = array("Title" => "Gravitational Anomalies",
                  "File" => "links/gravitational_anomalies.txt",
                  "Link" => "gravitational-anomalies.php",
                  "Description" => "Links to websites with information about various gravitational anomalies not explained current current understanding of gravity.",
                  "Keywords" => "gravitational anomalies, Foucault's pendulum, gravity eclipse, Von Braun gravity, ALLAIS EFFECT, PARACONICAL PENDULUM, Maurice ALLAIS",
                  "Menu" => 1);
$links[11] = array("Title" => "Spin Superradiance",
                  "File" => "links/spin_superradiance.txt",
                  "Link" => "spin-superradiance.php",
                  "Description" => "Bob Lazar's antimatter reactor is really just a spin super-radiance device. What is it really and differences between atomic superradiance and spin superradiance",
                  "Keywords" => "spin superradiance, super radiance, spin superradiant, atomic superradiance, PURE SPIN SUPERRADIANCE, Quantum Spin Tunneling, Superradiant Operation, Spin Masers, spin maser, Coherent radiation, exchange interactions, Spin Superradiance patent, Spin Superradiance patents, bob lazar, antimatter reactor",
                  "Menu" => 1);
$links[12] = array("Title" => "Spinwave Technology intro videos",
                  "File" => "links/swt_videos.txt",
                  "Link" => "swt-videos.php",
                  "Description" => "Links to George Bugh's videos on Youtube introducting Spin Wave Technology",
                  "Keywords" => "spin wave technology, training video, introduction video, research video, videos, powerpoint presentation video, spin entanglement, gravity inertia video",
                  "Menu" => 1);

$links[13] = array("Title" => "The Laser, Fundamentals and Theory of Operation",
                  "File" => "links/lasers.txt",
                  "Link" => "lasers.php",
                  "Description" => "Links to websites about what a laser is and how lasers work",
                  "Keywords" => "Light Amplification by Stimulated Emission of Radiation, coherent emision, electromagnetic radiation, lasers, laser, metastable state, theory of operation, population inversion, ",
                  "Menu" => 1);
                  
$links[14] = array("Title" => "Magnetic Forces at Microwave Frequencies",
                  "File" => "links/magnetic_forces_at_microwave_frequencies.txt",
                  "Link" => "magnetic-forces-at-microwave-frequencies.php",
                  "Description" => "Link to George Bugh's video on Youtube about magnetic forces at microwave frequencies and how it relates to technology described by Bob Lazar many years ago",
                  "Keywords" => "magnetic attraction
magnetic replusion, microwave engineering, bob lazar, area 51, element 115, gravity amplifier, gravity amplifiers, gravity emitter, gravity emitters, ufo, uav, free energy, free energy device, free energy devices, vasant corporation, george bugh,",
                  "Menu" => 1); 
                  

                  
                  
// NEWS ========================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here", (Limit to 50 characters)
//                               "File" => "filename.txt",     (Name of .txt file to be read into the content section of the web page)
//                               "Menu" => [0 / 1] );          ('1' means the item will appear on the menu, '0' means it will not.)
$news[1] = array("Title" => "George Bugh invited to speak at ISGAC2023",
                 "File" => "news/isgac2023.txt",
                 "Link" => "isgac2023.php",
                 "Description" => "George Bugh will be presenting at the 2023 INTERNATIONAL SUMMIT ON GRAVITATION, ASTROPHYSICS AND COSMOLOGY",
                 "Keywords" => "electromagnetism, gravity, free energy research, gravity research, antigravity, free energy device, overunity, over unity, perpetual motion, aerospace defense study,  classical electrodymanics, quantum electrodynamics, qed, research results, Ernst Mach, mach's principle, mach's conjecture, inertial resistance, inerial mass, theory of inertia",
                 "Menu" => 1);

$news[2] = array("Title" => "Aerospace Defense Research, Free Energy and Antigravity Possible",
                 "File" => "news/jul_12_2003.txt",
                 "Link" => "jul-12-2003.php",
                 "Description" => "Research study of free energy devices, some with reported antigravity effects.",
                 "Keywords" => "free energy research, gravity research, antigravity, free energy device, overunity, over unity, perpetual motion, aerospace defense study,  classical electrodymanics, quantum electrodynamics, qed, research results, Ernst Mach, mach's principle, mach's conjecture, inertial resistance, inerial mass, theory of inertia",
                 "Menu" => 1);
                 
$news[3] = array("Title" => "Potential of Spin Wave Technology for the Future of Powered Flight",
                 "File" => "news/future_potential_for_powered_flight.txt",
                 "Link" => "future-potential-for-powered-flight.php",
                 "Description" => "Potential of Spin Wave Technology for the Future of Powered Flight, 
                                   information included in the book  
                                   One Hundred Years of Powered Flight 1902 - 2003",
                 "Keywords" => "Royal Aeronautical Society, spin wave technology, antigravity technology, aerospace defense publication, #aerospace #space #aerospaceindustry #nasa #aeronautics #ussf #usaf #pentagon #aeronauticalengineering #aviation",
                 "Menu" => 1);

$news[4] = array("Title" => "What Powers those Pentagon verified UFOs?",
                 "File" => "news/what_powers_those_pentagon_verified_ufos.txt",
                 "Link" => "what-powers-those-pentagon-verified-ufos.php",
                 "Description" => "A summary of our research into so called 'free energy' devices and their reported antigravity effects",
                 "Keywords" => "Pentagon verified UFOs, UFO propulsion systems, Advanced aerospace technology, Unidentified Aerial Phenomena (UAP), Extraterrestrial spacecraft, Government disclosure on UFOs, Unexplained aerial sightings, Military encounters with UFOs, Alien technology research, Aerospace engineering advancements",
                 "Menu" => 1);
                 
$news[5] = array("Title" => "Interview of CEO George Bugh by Gitika Gorthi",
                 "File" => "news/interview-of-george-bugh-03-2021.txt",
                 "Link" => "interview-of-george-bugh-03-2021.php",
                 "Description" => "An interview of George J Bugh by Gitika Gorthi in March 2021",
                 "Keywords" => "news interview, Gitika Gorthi, IgnitedThinkers, space champion",
                 "Menu" => 1);
                 
$news[6] = array("Title" => "Site Updates",
                 "File" => "",
                 "Link" => "updates.php",
                 "Description" => "Vasant Corporation news updates.  ",
                 "Keywords" => "news updates, website updates, website changes, corporate news",
                 "Menu" => 1);
                 
                 




// SERVICES ====================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here", (Limit to 50 characters)
//                               "File" => "filename.txt",     (Name of .txt file to be read into the content section of the web page)
//                               "Menu" => [0 / 1] );          ('1' means the item will appear on the menu, '0' means it will not.)
$services[2] = array("Title" => "Consulting Services",
                  "File" => "services/consulting.txt",
                  "Link" => "consulting.php",
                  "Description" => "Consulting Services",
                  "Keywords" => "tbd",
                  "Menu" => 1);
                  
$services[1] = array("Title" => "Presentation Services",
                  "File" => "services/presentations.txt",
                  "Link" => "presentations.php",
                  "Description" => "Presentations Services",
                  "Keywords" => "tbd",
                  "Menu" => 1);

// DOWNLOADS ====================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here", (Limit to 50 characters)
//                               "File" => "filename.txt",     (Name of .txt file to be read into the content section of the web page)
//                               "Menu" => [0 / 1] );          ('1' means the item will appear on the menu, '0' means it will not.)
$downloads[1] = array("Title" => "File Downloads",
                  "File" => "downloads/downloads.txt",
                  "Link" => "downloads.php",
                  "Description" => "Downloadable files and presentations from the Vasant Corporation",
                  "Keywords" => "magnetic circuit vs electric circuit, magnetic materials, research files, magnetic levitation, nature of time, 3d time, project proposals, student projects, student project, zip file",
                  "Menu" => 1);

// ABOUT US ====================================================================
// FORMAT: $arrayName[n] = array("Title" => "Page Title Here", (Limit to 50 characters)
//                               "File" => "filename.txt",     (Name of .txt file to be read into the content section of the web page)
//                               "Menu" => [0 / 1] );          ('1' means the item will appear on the menu, '0' means it will not.)
$about[1] = array("Title" => "About the Vasant Corporation",
                  "File" => "about/about_us.txt",
                  "Link" => "about.php",
                  "Description" => "Summary of the Vasant Corporation",
                  "Keywords" => "cage code, cagecode, duns number, dunsnumber, incorporation date, research files, instructional videos, learning materials, lectures, spin wave technology, power generation, propulsion, signal processing,  communications, electromagnetic, particle spin interactions, spin axis orientations",
                  "Menu" => 1);
$about[2] = array("Title" => "Spin Wave Technology Global Market Assessment",
                  "File" => "about/cp1.txt",
                  "Link" => "cp1.php",
                  "Description" => "Vasant Corporation's Assessment of the Global Market total value of Spin Wave Technology.",
                  "Keywords" => "gravity modification propulsion, economically free energy, national debt, big oil, climte change, global warming",
                  "Menu" => 1);
$about[3] = array("Title" => "Our Consulting Fees for Spin Wave Technology",
                 "File" => "about/cp2.txt",
                 "Link" => "cp2.php",
                 "Description" => "The Vasant Corporation's proposed consulting fees related to spin wave technology.",               
                 "Keywords" => "consulting fees, compensation, fee, fees",
                 "Menu" => 1);
$about[4] = array("Title" => "Assessment of the Human Race",
                  "File" => "about/cp3.txt",
                  "Link" => "cp3.php",
                  "Description" => "Vasant Corporation assessment of Earth primates and in particular the species homosapien",
                  "Keywords" => "Assessment, Earth primates, species, homo sapien, homosapien, matriarch, matriarchs, matriarcal, matriarchal society, amazon woman, amazon women, evolution, primate primates",
                  "Menu" => 1);
$about[5] = array("Title" => "Government Patent Hoarding and Freedom",
                  "File" => "about/cp4.txt",
                  "Link" => "cp4.php",
                  "Description" => "Vasant Corporation editorial article about U. S. Government Patent Hoarding of advanced technologies and Freedom",
                  "Keywords" => "nuclear fusion, nuclear fission, secret technology, patent hoarding, advanced technology",
                  "Menu" => 1);



// DID YOU KNOW ITEMS ==========================================================
// FORMAT: $arrayName[n] = array("Text" => "Text goes here",                 (Prefix all entries with elipses [...])
//                               "Link" => "http://url.for.read.more.link"); (Leave blank for no URL. If left blank the "Read more..." text will not be shown.)
$dyk[1] = array("Text" => "...pressing 'Ctrl + D' will bookmark this page in your browser for easier access?",
                "Link" => "");
                
$dyk[2] = array("Text" => "...that spin waves can transport information from one location to another?",
                "Link" => "what-can-swt-do.php");
                
$dyk[3] = array("Text" => "...'Vasant in Sanskrit means the season Spring?",
                "Link" => "");
                
$dyk[4] = array("Text" => "...'Vasant' was selected to be dyslexic for 'savant'? The accent is on the second syllable.",
                "Link" => "");
                
$dyk[5] = array("Text" => "...the spin of a charged particle causes it to have a magnetic field like a small bar magnet?",
                "Link" => "swt-magnetic-levitation.php");
                
$dyk[6] = array("Text" => "...that spin waves can transport energy from one location to another?",
                "Link" => "spinwaves-power-generation.php");
                
$dyk[7] = array("Text" => "...Vasant Corporation offers a CD which includes an instructional video on how to produce spin waves?",
                "Link" => "vc001.php");
                
$dyk[8] = array("Text" => "...a precessing electron is like a rotating bar magnet?",
                "Link" => "about-spinwaves.php");

// UPDATES =====================================================================
// FORMAT: $arrayName[n] = array("Subject" => "Subject goes here",  (Limit to 60 characters)
//                               "Date" => "mm/dd/yyyy",            (Enter date of when the update was added)
//                               "Text" => "Text goes here");       (May include simple HTML tags. Double quotes ["] and dollar signs [$] MUST be escaped with a backslash [ i.e \" and \$ ]")
$updates[1] = array("Subject" => "Vasant Corporation Goes Online",
                    "Date" => "07/04/2001",
                    "Text" => "<P>The beta version of this Website has been posted while design changes and added features are in the works.</P>
                               <P>We apologize for any inconvenience this may cause. For the full version of this site, please visit us at a later date. Thank you.</P>"
             );

$updates[2] = array("Subject" => "Permission Pending",
                    "Date" => "07/23/2001",
                    "Text" => "<P>George Bugh's employer has taken issue with his working with the Vasant Corporation to sell his science files.</P>
                               <P>Already two of three legal departments have given him permission to proceed but there is one hold out and we hope soon to have the matter resolved. However, until this is cleared up we can not at this time sell the CD of these science files and instructional video.</P>
                               <P>More specifically, his employer's legal counsel for staffing and human resources has given Mr. Bugh permission to engage in an outside business of working with the Vasant Corporation to sell these science papers. In addition, the legal department for communications and publications has given permission to publish these science files as long as there is no reference to Mr Bugh's employer. However, the legal department for patents and intellectual property is reviewing Mr Bugh's science files and is not giving Mr. Bugh permission to proceed until their approval. They have stated that approval will be granted if they find that there nothing that is in conflict with existing company business ventures and if these files are not of future business interest. They initially said their decision would come rather quickly after looking over the files however it is taking much longer and they are not returning calls so we are waiting.</P>
                               <P>Please check back in a month and we hope to have the matter resolved and again offer these files for sale.</P>"
             );

$updates[3] = array("Subject" => "Permission Granted",
                    "Date" => "08/02/2001",
                    "Text" => "<P>Fasten your seat belts. We have clearance for take off.</P>"
             );

$updates[4] = array("Subject" => "First Publication",
                    "Date" => "11/30/2001",
                    "Text" => "<P>Vasant Corporation has released its first publication.</P>
                               <P><B>Product Information:</B></P>
                               <P><B>Title:</B> Spin Wave Technology Initial Release<BR>
                               <B>ISBN:</B> ISBN 097166160X<BR>
                               <B>Publisher:</B> Vasant Corporation<BR>
                               <B>Author:</B> George J. Bugh
                               <P><A HREF=\"pubs.php?cat=2\">More Information</A></P>"
             );
             
$updates[5] = array("Subject" => "More Permissions Granted",
                    "Date" => "02/20/2002",
                    "Text" => "<P>Mr. Bugh has requested and received permission from his day job employer to give copyrights to the Vasant Corporation for new research papers about using spin wave technology in MagLev transportation systems.
                               <HR WIDTH=200 NOSHADE COLOR=#000000 SIZE=1>
                               <P>Excerpts of communications between parties involved:</P>
                               <P><B>Mr. Bugh wrote:</B> \"... This time it is about using spin waves in MagLev transportation compartment levitation and propulsion. It is based on similar principles to MagLev Trains. I wanted to go ahead and find out now if I have permission to publish something on this subject before I put too much effort into it. It is not related to anything I do here at work.\"</P>
                               <P><B>Legal Dept. wrote:</B> \"Just have your boss send me an e-mail saying this is not related to your [Company X] work.\"</P>
                               <P><B>Company X Manager wrote:</B> \"I concur that the subject matter is not related to his work at [Company X].\"</P>"
             );

$updates[6] = array("Subject" => "Paperback of \"Spin Wave Technology Initial Release\"",
                    "Date" => "12/30/2002",
                    "Text" => "<P>We have released the paperback edition</P>
                               <P><B>Product Information:</B></BR>
                               <B>Title:</B> Spin Wave Technology Initial Release<BR>
                               <B>ISBN:</B> 0971661618<BR>
                               <B>Publisher:</B> Vasant Corporation<BR>
                               <B>Author:</B> George J. Bugh
                               <P>This paperback edition includes corrections and updates to referenced scientific research support links on the internet. In addition there are 4 preliminary chapters on using spin wave technology in magnetic levitation systems.</P>
                               <P><A HREF=\"pubs.php?cat=2\">More Information</A></P>"

             );

$updates[7] = array("Subject" => "Correction Notice 1",
                    "Date" => "03/02/2003",
                    "Text" => "<P>Librarians, please attach the following correction notice to the inside front cover of the referenced publication:
<HR WIDTH=200 NOSHADE COLOR=#000000 SIZE=1>
<P><B>Title:</B> Spin Wave Technology Initial Release<BR>
<B>ISBN:</B> ISBN 097166160X<BR>
<B>Correction:</B> In the electrical diagrams, the magnetic field direction vectors, relative to the motion of negative charges that cause them, are accidentally drawn backwards. This will be corrected in future publications. Please accept our apologies for this error.<BR>
<B>Publisher:</B> Vasant Corporation<BR>
<B>Author:</B> George J. Bugh
</P>"

             );

$updates[8] = array("Subject" => "Correction Notice 2; regarding ''proton popping''",
                    "Date" => "05/15/2003",
                    "Text" => "<P><B>Product Information:</B></br>
                               <B>Title:</B> Spin Wave Technology Initial Release<BR>
                               <B>ISBN:</B> 097166160X and 0971661618<BR>
                               <B>Publisher:</B> Vasant Corporation<BR>
                               <B>Author:</B> George J. Bugh<br><br>
                                  Chapter 36, page 202, regarding the information about ''proton popping'' using a highly negative electrostatic field during proton spin flips: The creation of +copper ions does not make the protons susceptible to nuclear magnetic resonance. The +ions are formed in the process of applying a high -e electrostatic field; however, the naturally abundant forms of copper as isotopes Cu-63 and Cu-65 in copper samples are already susceptible to nuclear magnetic resonance techniques to initiate proton spin flips in external magnetic fields. This will be clarified in future editions.</P>"
             );


$updates[9] = array("Subject" => "Vasant Corporation website goes Offline",
                    "Date" => "10/21/2004",
                    "Text" => "<P>This Vasant Corporation website was taken down after the US DOD Defense Security Service (DSS) took action to remove Mr. Bugh's Security Clearance, stating that the website provided a means for foreign nationals to contact Mr. Bugh and ask questions about his work. Later the US DOD DSS dropped their case against Mr. Bugh, however we kept the website down after becoming aware of the government's concerns.</P>"
             );

$updates[10] = array("Subject" => "Vasant Corporation website goes Online again",
                    "Date" => "04/14/2014",
                    "Text" => "<P>This Vasant Corporation website is back online now since Mr. Bugh is in semi-retirement, working only part time and he has less concern about keeping his security clearance. In any case, the US DOD DSS had dropped their objection to the website providing a means to contact Mr. Bugh.</P>
                    <p>Mr. Bugh is now accepting invitations to colleges and conferences to explain Spin Wave Technology better.</P>"

             );

$updates[11] = array("Subject" => "George Bugh retires from Lockheed Martin",
                    "Date" => "08/20/2015",
                    "Text" => "<P>Mr. Bugh has retired from Lockheed Martin Aeronautics Company Fort Worth as of August 20, 2015 and now works full time for the Vasant Corporation. He hired on back on August 2nd, 1982 with General Dynamics Fort Worth to work on F-16 flight simulators in the Flight Simulation Laboratory. Later the Fort worth division of General Dynamics was sold to Lockheed and later still Lockheed and Martin Marietta merged to become Lockheed Martin Corporation. Mr. Bugh worked at the same location for 33 years before retiring in 2015.</P>"

             );
             
$updates[12] = array("Subject" => "Added \"Spin Superradiance\" to the Links",
                    "Date" => "04/23/2018",
                    "Text" => "<P>This website has been updated to add information about spin superradiance to the Links section. Also, various dead URL links throughout the website have been updated to working URL links.</P>"

             );
             
$updates[13] = array("Subject" => "Updated various webpages under \"About Us\"",
                    "Date" => "04/05/2020",
                    "Text" => "<P>Mostly updated the Spin Wave Technology Global Market Assessment webpage under the 'About Us' dropdown menu</P>"

             );

$updates[14] = array("Subject" => "Added college class projects proposals",
                    "Date" => "04/19/2020",
                    "Text" => "<P>Under the 'File Downloads' drop down menu, the previously added project proposals for college students has been updated with a new proposal presentation: 'project_proposals_for_fall_of_2020'  </P>"

             );
             
$updates[15] = array("Subject" => "Added article: Making Pseudo Element 115",
                    "Date" => "07/09/2020",
                    "Text" => "<P>Under the 'Articles' drop down menu, there is a new article titled: 'Making Pseudo Element 115' </P>"

             );

$updates[16] = array("Subject" => "Added news: What Powers those Pentagon verified UFOs",
                    "Date" => "09/21/2020",
                    "Text" => "<P>See the news release under the 'News' drop down menu.</P>"

             );
             
$updates[17] = array("Subject" => "Added article: Gravitational mass versus Inertial mass",
                    "Date" => "12/22/2020",
                    "Text" => "<P>See the new article under the 'Articles' drop down menu.  </P>"

             );
             
$updates[18] = array("Subject" => "Added article: Gluon Frequency in Heavy Elements",
                    "Date" => "01/12/2021",
                    "Text" => "<P>See the new article under the 'Articles' drop down menu.  </P>"

             );
             
$updates[19] = array("Subject" => "Added article: What is a Free Energy Device?",
                    "Date" => "01/17/2021",
                    "Text" => "<P>See the new article under the 'Articles' drop down menu.  </P>"

             );
             
$updates[20] = array("Subject" => "Added news: Interview of George Bugh by Ms. Gitika Gorthi",
                    "Date" => "04/04/2021",
                    "Text" => "<P>See the news article under the 'News' drop down menu.  </P>"

             );

$updates[21] = array("Subject" => "Added link: Magnetic Forces at Microwave Frequencies",
                    "Date" => "07/08/2021",
                    "Text" => "<P>See the link to this video under the 'Links' drop down menu: Magnetic Attraction and Repulsion at Microwave Frequencies.  </P>"

             );

$updates[22] = array("Subject" => "Updated download file: Delayed Lenz's Law",
                    "Date" => "05/09/2022",
                    "Text" => "<P>Under the 'Downloads' pulldown menu; the research journal file 'Delayed Lenzs Law 04-27-2014' has been updated. The date in the file name is kept the same because of other websites that have links to the earlier date of the file.  </P>"

             );
                          
$updates[23] = array("Subject" => "Added news 'George Bugh invited to speak at ISGAC2023'",
                    "Date" => "05/26/2022",
                    "Text" => "<P>Under this 'News' pulldown menu; see the article about George Bugh speaking at the 2023 International Summit on Gravitation, Astrophysics and Cosmology.  </P>"

             );
             
$updates[24] = array("Subject" => "Updated download file again: Delayed Lenz's Law",
                    "Date" => "06/24/2022",
                    "Text" => "<P>Under the 'Downloads' pulldown menu; the research journal file 'Delayed Lenzs Law 04-27-2014' has been updated again regarding modifying inertia. The date in the file name is kept the same because of other websites that have links to the earlier date of the file.  </P>"

             );
             
$updates[25] = array("Subject" => "Added George Bugh's gravity videos to Downloads",
                    "Date" => "06/30/2022",
                    "Text" => "<P>Under the 'Downloads' pulldown menu; George Bugh's original 3 videos about gravity have been combined into 1 video file: george-bugh-2016-gravity-videos.mp4 (288 MB).  </P>"

             );
             
$updates[26] = array("Subject" => "Added update to 'Gluon Frequency in Heavy Elements'",
                    "Date" => "06/30/2022",
                    "Text" => "<P>Under the 'Articles' pulldown menu, the article 'Gluon Frequency in Heavy Elements' has been updated to include information about how to lower the frequency to become more accessible.  </P>"

             );
             
$updates[27] = array("Subject" => "Added update to 'Magnetic Levitation With Spin Waves'",
                    "Date" => "08/15/2022",
                    "Text" => "<P>Under the 'Articles' pulldown menu, the article 'Magnetic Levitation With Spin Waves' has been updated to give notice of a mistake in the last paragraph of the downloadable file.  </P>"
             );
$updates[28] = array("Subject" => "Updated download files about magnetic permeability",
                    "Date" => "10/02/2022",
                    "Text" => "<P>Under the 'Downloads' pulldown menu, the download files about magnetic-permeability have been updated to fix some bad links and typos.  </P>"
             );
$updates[29] = array("Subject" => "Added 'Link between Electromagnetism and Gravity'",
                    "Date" => "01/14/2023",
                    "Text" => "<P>Under the 'Downloads' pulldown menu, added 'link-between-electromagnetism-and-gravity' PowerPoint presentation in .pdf and .pps formats. Also added a narrated version of the same in .ppsx format. </P>"
             );
$updates[30] = array("Subject" => "Added 'Nature of Time' presentation to download files",
                    "Date" => "01/31/2023",
                    "Text" => "<P>Under the 'Downloads' pulldown menu, added 'Nature of Time' PowerPoint presentation in .pdf and .pps formats.  </P>"
             );
$updates[31] = array("Subject" => "Re-activated vasantcorporation.co.uk mirror site",
                    "Date" => "04/28/2023",
                    "Text" => "<P>We are still getting the cob webs out and having a few hicups but the mirror site: 'https://www.vasantcorporation.co.uk' should be accessible from the Links menu and as always, if niether site is accessible, please check here:<br><br> https://web.archive.org/web/20230000000000*/vasantcorporation.com <br><br>If neither site is accessible from your location, please VPN to a different region and try again.</P>"
             );
$updates[32] = array("Subject" => "Added supplemental animations to download files",
                    "Date" => "05/09/2023",
                    "Text" => "<P>The in-work file: electromagnetism-gravity-supplemental-animations.pps has been added to the Downloads section to provide animations of spin interactions discussed in the file: An Exploitable Link between Electromagnetism and Gravity</P>"
             );           
$updates[33] = array("Subject" => "Added classical atom research file to download files",
                    "Date" => "05/14/2023",
                    "Text" => "<P>The in-work files: classical-atom-research.pdf and classical-atom-research.pps have been added to the download files.</P>"
             );   
$updates[34] = array("Subject" => "Added 'Services' to website menu",
                    "Date" => "06/08/2023",
                    "Text" => "<P>The 'Services' category has been added to the website's menu bar and this loads a new webpage with links to 'Presentation Services' and 'Consulting Services'. </P>"
             ); 
$updates[35] = array("Subject" => "Added 'Mirror Websites' to Links menu",
                    "Date" => "06/12/2023",
                    "Text" => "<P>Add a new Links category of Mirror Websites </P>"
             );                          
$updates[36] = array("Subject" => "Added Equivalence Principle research to Downloads",
                    "Date" => "07/27/2023",
                    "Text" => "<P>The files equivalence-principle.pdf and equivalence-principle.pps have been added to the Downloads section. This research is in regards to development of an easy experiment people can do to verify or disprove the Gravity A and Gravity B theory. </P>"
             );    
$updates[37] = array("Subject" => "Added Spin Wave Technology Book pdf to Downloads",
                    "Date" => "07/27/2023",
                    "Text" => "<P>Since others are selling this book illegally and possibly harvesting credit card data and installing malware, we have decided to make this book available for free here in the Downloads section. </P>"
             );  
               
?>
